/*
 * Decompiled with CFR 0.152.
 */
package fabric.fionathemortal.betterbiomeblend.common;

public final class Color {
    public static final float[] sRGBLUT = new float[256];
    static int[] fp32_to_srgb8_tab4;

    public static int makeRGBAWithFullAlpha(int R, int G, int B) {
        int result = (0xFF & R) << 16 | (0xFF & G) << 8 | 0xFF & B | 0xFF000000;
        return result;
    }

    public static int RGBAGetR(int color) {
        int result = color >> 16 & 0xFF;
        return result;
    }

    public static int RGBAGetG(int color) {
        int result = color >> 8 & 0xFF;
        return result;
    }

    public static int RGBAGetB(int color) {
        int result = color & 0xFF;
        return result;
    }

    public static float byteToNormalizedFloat(int color) {
        float result = (float)(0xFF & color) / 255.0f;
        return result;
    }

    public static byte normalizedFloatToByte(float color) {
        byte result = (byte)Math.round(color * 255.0f);
        return result;
    }

    public static float sRGBToLinear(float color) {
        float clamped = Math.max(Math.min(color, 1.0f), 0.0f);
        float result = clamped <= 0.040448237f ? color / 12.92f : (float)Math.pow((clamped + 0.055f) / 1.055f, 2.4f);
        return result;
    }

    public static float linearTosRGB(float color) {
        float clamped = Math.max(Math.min(color, 1.0f), 0.0f);
        float result = clamped <= 0.0031306685f ? clamped * 12.92f : 1.055f * (float)Math.pow(clamped, 0.4166666567325592) - 0.055f;
        return result;
    }

    public static float sRGBByteToLinearFloat(int color) {
        float result = sRGBLUT[0xFF & color];
        return result;
    }

    public static byte linearFloatTosRGBByte(float in) {
        int almostone = 0x3F7FFFFF;
        int minval = 0x39000000;
        float almostoneF = Float.intBitsToFloat(0x3F7FFFFF);
        float minvalF = Float.intBitsToFloat(0x39000000);
        if (!(in > minvalF)) {
            in = minvalF;
        }
        if (in > almostoneF) {
            in = almostoneF;
        }
        int inBits = Float.floatToIntBits(in);
        int tab = fp32_to_srgb8_tab4[inBits - 0x39000000 >>> 20];
        int bias = tab >>> 16 << 9;
        int scale = tab & 0xFFFF;
        int t = inBits >>> 12 & 0xFF;
        return (byte)(bias + scale * t >>> 16);
    }

    public static void sRGBByteToOKLabs(int color, float[] dest, int index) {
        int rIn = Color.RGBAGetR(color);
        int gIn = Color.RGBAGetG(color);
        int bIn = Color.RGBAGetB(color);
        float r = Color.sRGBByteToLinearFloat(rIn);
        float g = Color.sRGBByteToLinearFloat(gIn);
        float b = Color.sRGBByteToLinearFloat(bIn);
        float l = 0.41222146f * r + 0.53633255f * g + 0.051445995f * b;
        float m = 0.2119035f * r + 0.6806995f * g + 0.10739696f * b;
        float s = 0.08830246f * r + 0.28171885f * g + 0.6299787f * b;
        float lRoot = (float)Math.cbrt(l);
        float mRoot = (float)Math.cbrt(m);
        float sRoot = (float)Math.cbrt(s);
        float LResult = 0.21045426f * lRoot + 0.7936178f * mRoot - 0.004072047f * sRoot;
        float aResult = 1.9779985f * lRoot - 2.4285922f * mRoot + 0.4505937f * sRoot;
        float bResult = 0.025904037f * lRoot + 0.78277177f * mRoot - 0.80867577f * sRoot;
        dest[index] = LResult;
        dest[index + 1] = aResult;
        dest[index + 2] = bResult;
    }

    public static void OKLabsTosRGBByte(float L, float a, float b, byte[] dest, int index) {
        float l_ = L + 0.39633778f * a + 0.21580376f * b;
        float m_ = L - 0.105561346f * a - 0.06385417f * b;
        float s_ = L - 0.08948418f * a - 1.2914855f * b;
        float l = l_ * l_ * l_;
        float m = m_ * m_ * m_;
        float s = s_ * s_ * s_;
        float rResult = 4.0767417f * l - 3.3077116f * m + 0.23096994f * s;
        float gResult = -1.268438f * l + 2.6097574f * m - 0.34131938f * s;
        float bResult = -0.0041960864f * l - 0.7034186f * m + 1.7076147f * s;
        byte rByte = Color.linearFloatTosRGBByte(rResult);
        byte gByte = Color.linearFloatTosRGBByte(gResult);
        byte bByte = Color.linearFloatTosRGBByte(bResult);
        dest[index] = rByte;
        dest[index + 1] = gByte;
        dest[index + 2] = bByte;
    }

    public static void OKLabsTosRGBAInt(float L, float a, float b, int[] dest, int index) {
        int color;
        float l_ = L + 0.39633778f * a + 0.21580376f * b;
        float m_ = L - 0.105561346f * a - 0.06385417f * b;
        float s_ = L - 0.08948418f * a - 1.2914855f * b;
        float l = l_ * l_ * l_;
        float m = m_ * m_ * m_;
        float s = s_ * s_ * s_;
        float rResult = 4.0767417f * l - 3.3077116f * m + 0.23096994f * s;
        float gResult = -1.268438f * l + 2.6097574f * m - 0.34131938f * s;
        float bResult = -0.0041960864f * l - 0.7034186f * m + 1.7076147f * s;
        byte rByte = Color.linearFloatTosRGBByte(rResult);
        byte gByte = Color.linearFloatTosRGBByte(gResult);
        byte bByte = Color.linearFloatTosRGBByte(bResult);
        dest[index] = color = Color.makeRGBAWithFullAlpha(rByte, gByte, bByte);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            float color = Color.byteToNormalizedFloat(i);
            Color.sRGBLUT[i] = Color.sRGBToLinear(color);
        }
        fp32_to_srgb8_tab4 = new int[]{7536653, 7995405, 0x80000D, 8847373, 0x8D000D, 9699341, 10092557, 10551309, 10944538, 11796506, 12648474, 13500442, 14286874, 15138842, 15990810, 0x101001A, 17694771, 19398707, 21037107, 22741043, 24444979, 26148915, 27787315, 29491251, 31195239, 34537575, 37945447, 41287783, 44695655, 48037991, 51445863, 54788199, 58196174, 64946382, 71696590, 78446798, 85197006, 91947205, 98369724, 104530101, 110559576, 121766210, 132317488, 142278944, 151716114, 160694534, 169279740, 177537266, 185532875, 200540590, 214630805, 227869056, 240517486, 252510558, 263979344, 274923843, 285672036, 305660478, 324469277, 342229505, 359006697, 374997459, 390332864, 405012911, 419300145, 446038782, 471139026, 494797485, 517210765, 538575472, 559022678, 578617920, 597623875, 633340926, 666829764, 698418066, 728367975, 756876097, 784204575, 810353408, 835782064, 883426645, 928122119, 970261701, 1010238603, 1048314968, 1084752938, 1119683585, 1153566616, 1217267486, 1276905142, 1333134941, 1386546704, 1437337036, 1485964687, 1532560729, 1577847331, 1662781824, 1742407926, 1817512063, 1888749592, 1956644797, 2021459820, 2083718947};
    }
}

